/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.FSPCMCustomHWSMessage;
import com.ibm.hsc.fsp.FSPCMIdGenerator;
import com.ibm.hsc.fsp.FSPCMReqTable;
import com.ibm.hsc.fsp.FSPCMReqTableEntry;
import com.ibm.hsc.fsp.FspCmdToken;
import com.ibm.hsc.fsp.FspInDataHandler;
import com.ibm.hsc.fsp.HWSvrSocket;
import com.ibm.hsc.fsp.ManagedSysConn;
import com.ibm.hsc.objmgr.console.OmConsoleMgr;
import java.io.IOException;

public class ConsoleCmdMgr
implements FspInDataHandler {
    private boolean mActive = false;
    private OmConsoleMgr mConsoleMgr = null;
    private FSPCMReqTable mCmReqTable = new FSPCMReqTable();
    private static boolean mPrintDetail = false;

    public ConsoleCmdMgr(OmConsoleMgr omConsoleMgr) {
        this.mConsoleMgr = omConsoleMgr;
    }

    public void reinitialize() {
        this.mActive = true;
        HWSvrSocket.getInstance().addVport(0, this);
    }

    public HardwareServerMessage doHardwareServerCmd(String string, FSPCMCustomHWSMessage fSPCMCustomHWSMessage, byte[] byArray, int n) throws PIHscCmdMgrException {
        Object object;
        if (!this.mActive) {
            throw new PIHscCmdMgrException("0264", (Throwable)null);
        }
        if (n == 0) {
            n = ManagedSysConn.getTimeoutValue();
        }
        byte[] byArray2 = null;
        int n2 = FSPCMIdGenerator.getInstance().genReqId();
        try {
            object = HardwareServerMessage.buildCustomHWSMessage(fSPCMCustomHWSMessage.getMajorOpcode(), fSPCMCustomHWSMessage.getMinorOpcode(), 0, n2, byArray);
            byArray2 = ((HardwareServerMessage)object).toBytes();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
            throw new PIHscCmdMgrException("0204", exception);
        }
        try {
            object = new FspCmdToken();
            this.mCmReqTable.addRow(n2, string, Thread.currentThread(), (FspCmdToken)object, 1);
            if (mPrintDetail || !string.equals("ADD_CEC")) {
                System.out.println("Send cmd " + string + " to hardware server: " + new HexDump(byArray2, false).toString());
            } else {
                System.out.println("Send cmd " + string + " to hardware server. No detail print");
            }
            HWSvrSocket.getInstance().sendCommand(byArray2);
            ((FspCmdToken)object).sleep(n);
        }
        catch (InterruptedException interruptedException) {
            Trace.trace("apcmhscD", "FSPCmdMgr: EXPLICITLY woken up the request thread...");
        }
        catch (IOException iOException) {
            HSCLogUtils.serverLog(iOException, HSCLogUtils._CECClassLogInfo);
            throw new PIHscCmdMgrException("0204", iOException);
        }
        object = (FSPCMReqTableEntry)this.mCmReqTable.get(new Integer(n2));
        if (object == null) {
            System.out.println("cannot find reqEntry for: " + n2 + " mCmReqTable " + this.mCmReqTable);
            String string2 = HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", "0255", "", new String[]{"" + n2});
            throw new PIHscCmdMgrException(string2, (Throwable)null);
        }
        this.mCmReqTable.deleteRow(n2);
        HardwareServerMessage hardwareServerMessage = (HardwareServerMessage)((FSPCMReqTableEntry)object).getResp();
        if (hardwareServerMessage == null) {
            String string3 = HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", "0254", "", new String[]{string});
            throw new PIHscCmdMgrException(string3, (Throwable)null);
        }
        return hardwareServerMessage;
    }

    public void handleInData(HardwareServerMessage hardwareServerMessage) {
        if (!this.mActive) {
            System.out.println("Console cmd mgr is not active");
            return;
        }
        try {
            System.out.println("Entering processResponse...");
            if (hardwareServerMessage.isHSError()) {
                System.out.println("hardware server error");
                return;
            }
            int n = hardwareServerMessage.getCorrelator();
            System.out.println("cmd reqId " + n);
            FSPCMReqTableEntry fSPCMReqTableEntry = (FSPCMReqTableEntry)this.mCmReqTable.get(new Integer(n));
            if (fSPCMReqTableEntry == null) {
                System.out.println(">>>>> cannot find entry for reqid: " + n);
                System.out.println("_cmReqTable: " + this.mCmReqTable);
                return;
            }
            fSPCMReqTableEntry.setResp(hardwareServerMessage);
            Thread thread = fSPCMReqTableEntry.getReqThread();
            thread.interrupt();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public OmConsoleMgr getConsoleMgr() {
        return this.mConsoleMgr;
    }

    public void disconnect(boolean bl, long l) {
        if (bl) {
            this.mCmReqTable.clear(3);
            this.mActive = false;
            this.mConsoleMgr.hwSrvDisconnected(l);
        }
    }

    public boolean isActive() {
        return this.mActive;
    }

    static boolean printDetail() {
        return mPrintDetail;
    }

    public static void setPrintDetail(boolean bl) {
        mPrintDetail = bl;
    }
}

